definition module devicefunctions


// RWS ... from	mac_types		import	Event
import	osevent
// ... RWS
from	iostate			import	PSt, IOSt
/* RWS ...
from	receiverhandle	import	MessageEvent, SystemId, Id, 
								MessageError, ProcessUnknown, ReceiverUnable, ReceiverUnknown
*/
import receiverhandle
/* ... RWS */
// RWS --- from	device			import	Device, TimerDevice, MenuDevice, WindowDevice, ReceiverDevice
import device
import timertable								// PA: added
from	ostypes			import	Rect			// PA: added
from	ospicture		import	OSPictContext	// PA: added
from	oswindow		import	OSWindowPtr		// PA: added
from	windowaccess	import	WIDS			// PA: added
from	StdControlDef	import	SliderMove		// PA: added

::	DeviceFunctions i o l p								// The major device callback functions:
	=	{	dShow	:: ShowFunction      l p			// Show the device and its instances
		,	dHide	:: HideFunction      l p			// Hide the device and its instances
		,	dEvent	:: EventFunction i o l p			// Map an OSEvent to a DeviceEvent
		,	dDoIO	:: DoIOFunction  i o l p			// Handle a DeviceEvent for this device
		,	dOpen	:: OpenFunction      l p			// Open the initial device
		,	dClose	:: CloseFunction     l p			// Close the device and its instances
		}
::	ShowFunction      l p	:==	(IOSt l p) -> IOSt l p
::	HideFunction      l p	:==	(IOSt l p) -> IOSt l p
::	OpenFunction      l p	:==	(IOSt l p) -> IOSt l p
::	CloseFunction     l p	:==	(IOSt l p) -> IOSt l p
::	EventFunction i o l p	:==	(SchedulerEvent i o)
							 ->	(IOSt l p)
							 ->	(Bool, Maybe (DeviceEvent i o), SchedulerEvent i o, IOSt l p)
::	DoIOFunction  i o l p	:==	OSSleepTime
							 -> (DeviceEvent i o)
							 -> (PSt l p)
							 -> (OSSleepTime, DeviceEvent i o, PSt l p)

// RWS ??? move special events to devices
::	MsgEvent i o
	=	QASyncMessage		!(QASyncMessage i)
	|	ASyncMessage		!ASyncMessage
	|	SyncMessage			!(SyncMessage i o)

::	SchedulerEvent i o
	=	ScheduleOSEvent		!OSEvent ![Int]
	|	ScheduleMsgEvent	!(MsgEvent i o)
	|	ScheduleTimerEvent	!TimerEvent

::	DeviceEvent i o
//	Menu events:
	=	MenuTraceEvent			!MenuTraceInfo				// Menu item has been selected
//	Receiver events:
	|	ReceiverEvent (MsgEvent i o)						// A (bi/uni)directional (a)synchronous message event
//	Timer events:
	|	TimerEvent TimerEvent								// A timer event
//	Window events:
	|	CompoundScrollAction	!CompoundScrollActionInfo	// Scrolling should occur in a compound control
	|	ControlKeyboardAction	!ControlKeyboardActionInfo	// Keyboard action in a control
	|	ControlMouseAction		!ControlMouseActionInfo		// Mouse action in a control
	|	ControlSelection		!ControlSelectInfo			// Control has been selected
	|	ControlSliderAction		!ControlSliderInfo			// Slider control has been selected
	|	WindowActivation		!WIDS						// Window with id has been made activate
	|	WindowDeactivation		!WIDS						// Window with id has been made inactivate
	|	WindowKeyboardAction	!WindowKeyboardActionInfo	// Keyboard action in a window
	|	WindowMouseAction		!WindowMouseActionInfo		// Mouse action in a window
	|	WindowRequestClose		!WIDS						// Window with id should be closed
	|	WindowScrollAction		!WindowScrollActionInfo		// Scrolling should occur in a window
	|	WindowSizeAction		!WindowSizeActionInfo		// Window has obtained a new size
	|	WindowUpdate			!UpdateInfo					// Window and its controls should be updated
::	MenuTraceInfo
	=	{	mtId				:: !Id						// The Id of the menu that contains the menu item
		,	mtParents			:: ![Int]					// The submenus starting from mtId that contain the menu item (zero based index)
		,	mtItemNr			:: !Int						// The menu item that has been selected (zero based index)
		,	mtModifiers			:: !Modifiers				// The modifiers that were pressed at the moment of selection
		}
::	CompoundScrollActionInfo
	=	{	csaWIDS				:: !WIDS					// The Id/Ptr of the window/dialogue that contains the compound control
		,	csaItemNr			:: !Int						// The wItemNr  of the compound control
		,	csaItemPtr			:: !OSWindowPtr				// The wItemPtr of the compound control
		,	csaSliderMove		:: !SliderMove				// The user action on the compound control
		,	csaDirection		:: !Direction				// The direction of the scrollbar that is being selected
		}
::	ControlKeyboardActionInfo
	=	{	ckWIDS				:: !WIDS					// The Id/Ptr of the window/dialogue that contains the control
		,	ckItemNr			:: !Int						// The wItemNr  of the control
		,	ckItemPtr			:: !OSWindowPtr				// The wItemPtr of the control
		,	ckKeyboardState		:: !KeyboardState			// The KeyboardState of the action
		}
::	ControlMouseActionInfo
	=	{	cmWIDS				:: !WIDS					// The Id/Ptr of the window/dialogue that contains the control
		,	cmItemNr			:: !Int						// The wItemNr  of the control
		,	cmItemPtr			:: !OSWindowPtr				// The wItemPtr of the control
		,	cmMouseState		:: !MouseState				// The MouseState of the action
		}
::	ControlSelectInfo
	=	{	csWIDS				:: !WIDS					// The Id/Ptr of the window/dialogue that contains the control
		,	csItemNr			:: !Int						// The wItemNr  of the selected control
		,	csItemPtr			:: !OSWindowPtr				// The wItemPtr of the selected control
		,	csMoreData			:: !Int						// Additional data (index in case of PopUpControls; otherwise zero)
		,	csModifiers			:: !Modifiers				// The modifiers that were active when the control was selected
		}
::	ControlSliderInfo
	=	{	cslWIDS				:: !WIDS					// The Id/Ptr of the window/dialogue that contains the slider
		,	cslItemNr			:: !Int						// The wItemNr  of the selected slider
		,	cslItemPtr			:: !OSWindowPtr				// The wItemPtr of the selected slider
		,	cslSliderMove		:: !SliderMove				// The user action on the slider
		}
::	WindowKeyboardActionInfo
	=	{	wkWIDS				:: !WIDS					// The Id/Ptr of the window
		,	wkKeyboardState		:: !KeyboardState			// The KeyboardState of the action
		}
::	WindowMouseActionInfo
	=	{	wmWIDS				:: !WIDS					// The Id/Ptr of the window
		,	wmMouseState		:: !MouseState				// The MouseState of the action
		}
::	WindowScrollActionInfo
	=	{	wsaWIDS				:: !WIDS					// The Id/Ptr of the window
		,	wsaSliderMove		:: !SliderMove				// The user action on the window
		,	wsaDirection		:: !Direction				// The direction of the scrollbar that is being selected
		}
::	WindowSizeActionInfo
	=	{	wsWIDS				:: !WIDS					// The Id/Ptr of the window
		,	wsSize				:: !Size					// The new size of the window
		}
::	UpdateInfo
	=	{	updWIDS				:: !WIDS					// The Id of the window/dialogue to be updated
		,	updWindowArea		:: !Rect					// The area of the window/dialogue to be updated (case zero, no update)
		,	updControls			:: ![ControlUpdateInfo]		// For each control to be updated: its item nr and area (in window coordinates)
		,	updGContext			:: !Maybe OSPictContext		// The graphics context to be used
		}
::	ControlUpdateInfo
	=	{	cuItemNr			:: !Int						// The wItemNr of the control
		,	cuItemPtr			:: !OSWindowPtr				// The wItemPtr to the control (can be OSNoWindowPtr)
		,	cuArea				:: !Rect					// The update area of the control (in window coordinates)
		}

//	PA: added:
//	Basic access functions on events:
getMsgEventRecLoc	:: !(MsgEvent i o)	-> RecLoc

// RWS ...
getDeviceFunctions	:: !Device			-> DeviceFunctions i o .l .p

dummyDeviceFunctions :: DeviceFunctions i o .l .p
